/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.networking;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import net.fabricmc.fabric.impl.networking.PayloadTypeRegistryImpl;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.neoforged.neoforge.network.filters.GenericPacketSplitter;
import org.sinytra.fabric.networking_api.NeoNetworkRegistrar;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GenericPacketSplitter.class})
public class GenericPacketSplitterMixin {
    @Inject(method={"encode(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/protocol/Packet;Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void encode(ChannelHandlerContext ctx, Packet<?> packet, List<Object> out, CallbackInfo ci) {
        if (packet instanceof ClientboundCustomPayloadPacket) {
            PacketEncoder encoder;
            PayloadTypeRegistryImpl<? extends FriendlyByteBuf> registry;
            ClientboundCustomPayloadPacket clientboundCustomPayloadPacket = (ClientboundCustomPayloadPacket)packet;
            ChannelHandler channelHandler = ctx.pipeline().get("encoder");
            if (channelHandler instanceof PacketEncoder && (registry = NeoNetworkRegistrar.getPayloadRegistry((encoder = (PacketEncoder)channelHandler).getProtocolInfo().id(), PacketFlow.CLIENTBOUND)).get(clientboundCustomPayloadPacket.payload().type()) != null) {
                out.add(packet);
                ci.cancel();
            }
        } else if (packet instanceof ServerboundCustomPayloadPacket) {
            PacketEncoder encoder;
            ServerboundCustomPayloadPacket serverboundCustomPayloadPacket = (ServerboundCustomPayloadPacket)packet;
            Object registry = ctx.pipeline().get("encoder");
            if (registry instanceof PacketEncoder && ((PayloadTypeRegistryImpl)(registry = NeoNetworkRegistrar.getPayloadRegistry((encoder = (PacketEncoder)registry).getProtocolInfo().id(), PacketFlow.SERVERBOUND))).get(serverboundCustomPayloadPacket.payload().type()) != null) {
                out.add(packet);
                ci.cancel();
            }
        }
    }
}

